using System;
using System.Diagnostics;
using System.IO;
using System.Linq;
using Kampane;

namespace Clicker
{
	public static class Logger
	{
		public static readonly string MyLocation = Process.GetCurrentProcess().MainModule.FileName;

		public static readonly string LogLocation = Path.GetDirectoryName(MyLocation) + "/log.txt";

		public static bool FileLoggingEnabled = false;

		private static short LineCount = 0;

		public static void LogToFile(string title, params object[] args)
		{
			try
			{
				string text = ((args.Count() <= 0) ? title : string.Format(title, args));
				string lineText = $"{DateTime.Now.ToString()}: {text}{Environment.NewLine}";
				if (FileLoggingEnabled)
				{
					File.AppendAllText(LogLocation, lineText);
				}
				if (LineCount > 1000)
				{
					Console.Clear();
					LineCount = 1;
				}
				Console.ForegroundColor = ConsoleColor.White;
				Console.Write("{0} ", DateTime.Now.ToString());
				Console.ForegroundColor = ConsoleColor.Gray;
				Console.WriteLine(text);
				Console.ResetColor();
				LineCount++;
			}
			catch (Exception)
			{
			}
		}

		public static void LogToFile(string title, ConsoleColor color = ConsoleColor.Gray, string addon = "", params object[] args)
		{
			try
			{
				string lineText = string.Format(arg1: (args.Count() <= 0) ? (title + addon) : string.Format(title + addon, args), format: "{0}: {1}{2}", arg0: DateTime.Now.ToString(), arg2: Environment.NewLine);
				if (FileLoggingEnabled)
				{
					File.AppendAllText(LogLocation, lineText);
				}
				if (LineCount > 1000)
				{
					Console.Clear();
					LineCount = 1;
				}
				Console.ForegroundColor = ConsoleColor.DarkGray;
				Console.Write("{0} ", DateTime.Now.ToString());
				Console.ForegroundColor = color;
				Console.Write("{0}", title);
				if (addon.Length > 0)
				{
					Console.ForegroundColor = ConsoleColor.Gray;
				}
				if (addon.Length > 0)
				{
					Console.Write(": " + addon, args);
				}
				Console.WriteLine();
				Console.ResetColor();
				LineCount++;
			}
			catch (Exception)
			{
			}
		}

		public static string SaveOutput(string what = "")
		{
			if (!FileLoggingEnabled)
			{
				return "";
			}
			try
			{
				string path = Path.GetDirectoryName(MyLocation) + "\\log\\";
				Directory.CreateDirectory(path);
				path = path + DateTime.Now.Ticks + "-" + Program.CurrentWeb.Replace('?', '_').Replace('\\', '_').Replace('/', '_')
					.Replace('.', '_')
					.Replace(':', '_');
				File.AppendAllText(path + ".log", what);
				LogToFile("[SAVED OUTPUT]", ConsoleColor.DarkYellow, path);
				return path;
			}
			catch (Exception e)
			{
				LogToFile("[SAVEOUTPUT FUCKED UP]", ConsoleColor.Red, "{0}: {1} - {2}", e.Source, e.Message, e.StackTrace);
				return "";
			}
		}
	}
}
